
;;;Bosse-engineering                                                                                       
;;;Dipl.-Ing. Jrn Bosse                                                                                   
;;;Am Klei 5                                                                                               
;;;38458 Velpke                                                                                            
;;;Tel. 05364 / 989 677                                                                                    
;;;mobil. 0176 / 282 323 51                                                                                
;;;bosse@bosse-engineering.com                                                                             
;;;                                                                                                        
;;;--------------------------------------------------------------------------------------------------------
;;;Funktion c: 3DPS - Es werden 3D-Polylinien ausgewhlt, die, bezogen auf die xy-Ebene des WKS's, Schnitt-
;;;punkte oder Knoten ohne Sttzpunkte bilden. Dann werden an den Sttzpunkten Sttzpunkte eingefgt, die  
;;;Hhe fr den Schnittpunkt entsteht aus Interpolation oder freie Eingabe. An den Schnitt-/Knotenpunkten  
;;;knnen die 3D-Polylinien optional auch gebrochen werden.						   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
;;;globale Variablen:										   	   
;;;- JB_3DPS$DCL$_[x]_po (Positionen der Dialogfenster)							   
;;;- JB_3DPS_$DCL$_File (temporre DCL-Datei)								   
;;;                                                                              Jrn Bosse, 19.07.23	   
;;;--------------------------------------------------------------------------------------------------------



;;;aufrufenden Funktionen
(defun c:3DPS ( / )
  (JB_3DPS)
  )

;;;Intro
(defun JB_3DPS:Intro (str / )
  (princ "\nerstellt durch Bosse-engineering - www.bosse-engineering.com\n")
  (princ "\n----------------------3DPS(1.0), 20.07.23---------------------")
  (princ str)
  (princ "\n--------------------------------------------------------------")
  )




;;;Variablenliste
(defun JB_3DPS:v_liste ( / )
  '(
     ( "DboxSettings" . (
                         ( "Dbox1" .
                            (
                             ("JB_1_r3-r5" . 0);;;0 = Z1, 1 = Z2, 2 = Eingabe
                             )
                          )
                         )
      ))
  )


;;;Pfad fr SIC-Datei in Windows-User
(defun JB_3DPS:pfad_ini ( / )
  (strcat (JBf_String:Userpfad:WinUser
                           "LispData\\acad\\"     ;;;Hier ndern, wenn anderer Pfad gewnscht, z.B. MeineTools\\Sicherungen\\ => Der LAufwerksbuchstabe c:\\ wird automatisch gegen das Windows-Benutzerverzeichnis 
                           )"3DPS_sic.lsp")  ;;;getauscht, z.B. c:\\User\\[WindowsUsername]\\LispData\\acad\\
  )

;;;Hauptfunktion
(defun JB_3DPS ( / PFAD_INI V_LISTE OSMODE_ALT)
  (vl-load-com)

  (setq pfad_ini (JB_3DPS:pfad_ini))

  ;;;ab AutoCAD 2014, setzen von vertrauenswrdigen Pfaden fr Sicherungsdateien
  (if (JBf_AcadSystem:TrustedPaths?)
    (JBf_AcadSystem:TrustedPaths:Add (strcat(car(fnsplitl pfad_ini))"...")))

    (if (not(setq v_liste (if (findfile pfad_ini)
                          (load pfad_ini)nil)))
    (JBf_SIC:sichern
      (setq v_liste (JB_3DPS:v_liste))pfad_ini nil))
  
  (vla-startundomark (vla-get-activedocument(vlax-get-acad-object)))
  (JBf_init
    '(("CMDECHO" 0)
      ("DIMZIN" 3)
      ))
  
  
  (JB_3DPS:Intro "\n3DPS: 3D-Polylinien - Schnittpunkte.")

  
  

  (if (not
            (or (and JB_3DPS_$DCL$_File(findfile JB_3DPS_$DCL$_File))
                (setq JB_3DPS_$DCL$_File (JB_3DPS:dcl:Write))))
        (progn
          (alert "Die DCL-Datei konnte nicht geschrieben werden.")
          (exit)))


  (if (JB_3DPS:Bks-WKS:parallel-p)
    (JB_3DPS:Dbox1 v_liste pfad_ini)
      )
    
   
  (princ "\nEnde.")
  (setq Osmode_Alt (getvar "OSMODE"))
  (JBf_Reinit)
  (setvar "OSMODE" Osmode_Alt)
  (vla-endundomark (vla-get-activedocument(vlax-get-acad-object))) 
  (princ)
  )

 

(defun  JB_3DPS:v_liste:DboxSettings:get (key v_liste / )
  (cdr(assoc key(cdr (assoc "DboxSettings" v_liste))))
)


(defun JB_3DPS:v_liste:DboxSettings:put (key liste v_liste / DboxList) 
  (setq DboxList (cdr (assoc "DboxSettings" v_liste)))
  (setq DBoxList (JBf_list:subst:gc DBoxList liste key))
  (setq v_liste (JBf_list:subst:gc v_liste DBoxList "DboxSettings"))
  v_liste
  )


;;;Prfen, ob WKS oder BKS in xy-Ausrichtung zum WKS
(defun JB_3DPS:Bks-WKS:parallel-p ( / )
  (or(and(if (/=(getvar "WORLDUCS")1);;;wenn BKS
    (and(equal(caddr(trans '(1 0 0)1 0))0.0 0.0001)
        (equal(caddr(trans '(0 1 0)1 0))0.0 0.0001))
    'T)
      (equal(car (getvar "VIEWDIR"))0.0 0.0001)
      (equal(cadr (getvar "VIEWDIR"))0.0 0.0001)
         )
  (alert (strcat "Fr die Verwendung des Programms \"3DPS\" mssen Sie sich im WKS oder einem BKS, dessen xy-Ebenen-Ausrichtung der xy-Ebenen-Ausrichtung des Weltkoordinatenssystems entspricht.\n"
                 "Zudem muss die DRAUFSICHT auf das aktuelle Koordinatensystem aktiviert sein."))
     )
  )


;;;LW-Polylinien adden
;;;closedFlag :vlax-true oder :vlax-false
;;;koord als (apply 'append koord-List mit xy)
(defun JB_3DPS:SpList:Get:vla-PlList:LwPolyAdd:AddLWPoly(koords layer closedFlag space / KOORDSARRAY vla-LwPoly)
  (setq KoordsArray (vlax-make-safearray vlax-vbDouble (cons 0  (-(length koords)1))))
  (vlax-safearray-fill KoordsArray koords)
  (setq vla-LwPoly(vla-addLightweightPolyline space KoordsArray))
  (vla-put-layer vla-LwPoly layer)
  (vla-put-closed vla-LwPoly closedFlag)
  vla-LwPoly
  )



;;;2D-LW-Poly als Hilfslinie
(defun JB_3DPS:SpList:Get:vla-PlList:LwPolyAdd (vla-3dPoly space / COORDS2D N VLA-LWPOLY X)
  (setq n -1)
  (setq coords2d (vl-remove-if 'not
                   (mapcar '(lambda(X)
                              (setq n (+ n 1))
                              (if (/= n 2)
                                X
                                (progn
                                  (setq n -1)
                                  nil)))
                     (vlax-get vla-3dPoly 'Coordinates))))
  (setq vla-LwPoly (JB_3DPS:SpList:Get:vla-PlList:LwPolyAdd:AddLWPoly
                     coords2d
                     (vla-get-layer vla-3dPoly)
                     (vla-get-closed vla-3dPoly)
                     space))
  (list (vla-get-handle vla-3dPoly) vla-3dPoly vla-LwPoly)
  )


;;;vla-List fr 3D-Polylinien und LW-Polylinien-"Kopie"
(defun JB_3DPS:SpList:Get:vla-PlList (aws / N RETLIST SPACE VLA-OBJ)
  (setq space(if (= 1 (getvar "CVPORT"))
	   (vla-get-PaperSpace (vla-get-activedocument (vlax-get-acad-object)))
	   (vla-get-ModelSpace (vla-get-activedocument (vlax-get-acad-object)))
	)
        )
  (setq n 0)
  (repeat (sslength aws)
    (setq vla-obj (vlax-ename->vla-object (ssname aws n)))
    (if (=(vla-get-Objectname vla-obj) "AcDb3dPolyline")
      (setq RetList (cons (JB_3DPS:SpList:Get:vla-PlList:LwPolyAdd vla-obj Space) RetList))
      )
    (setq n (+ n 1)))
  (reverse RetList))

;;;Schnittpunkte zweier Linienobjekte
(defun JB_3DPS:SpList:Get:Intersect:SpList(vla-obj1 vla-obj2 / SpArray)

  (setq SpArray (vlax-invoke-method vla-obj1
                  'IntersectWith
                  vla-obj2 acExtendNone))

  (if(/= -1 (vlax-safearray-get-u-bound (vlax-variant-value SpArray)1))
    (JBf_List:ObjSchnitt:ArrayList->List (vlax-safearray->list(vlax-variant-value SpArray)) 3)))

;;;ArrayList in normale Liste
(defun JB_3DPS:SpList:Get:Intersect:SpList:ArrayList->List (ArrayList i / A N RETLIST SUBLIST)
  (setq n 0)
  (mapcar '(lambda(A)
             (setq n (+ n 1)
                   subList (cons A subList))
             (if (= n i)
               (setq retList (cons (reverse subList)retList)
                     n 0
                     subList nil)))ArrayList)
  retList)  

;;;Schnittpunktliste
(defun JB_3DPS:SpList:Get:Intersect (vla-PlList / RETLIST SPLIST VEKTOR X Y Z HandleList)
  (setq vektor(vlax-get(caddr(car vla-PlList))'Coordinates)
        vektor (list (car vektor)(cadr vektor)0))
  (mapcar '(lambda(X) (vla-move X (vlax-3d-point vektor)(vlax-3d-point '(0 0 0))))(mapcar 'caddr vla-PlList))

  (setq RetList
         (vl-remove-if 'not
           (mapcar '(lambda(X)
                      (if (setq RetList
                                 (vl-remove-if 'not
                                        (mapcar '(lambda(Y)
                                                   (if (/= (car X)(car y))
                                                     (if (not(member (strcat (car X)"$$"(car Y))HandleList))
                                                       (if(setq spList(JB_3DPS:SpList:Get:Intersect:SpList(caddr X) (caddr Y)))
                                                         (progn
                                                           (setq HandleList (append HandleList (list (strcat(car X)"$$"(car Y))(strcat(car Y)"$$"(car X)))))
                                                           (list (mapcar '(lambda(Z)(mapcar '+ Z vektor))spList) Y)
                                                           )
                                                         )
                                                       )
                                                     )
                                                   )
                                          vla-PlList)
                                        )
                                )
                                
                        (list X RetList)
                        )
                      )vla-PlList)
           )
        )
  (mapcar 'vla-delete (mapcar 'caddr vla-PlList))
  RetList)
           

;;;3D-Polylinien auswhlen und Schnittpunktliste zurckgeben
(defun JB_3DPS:SpList:Get( / AWS VLA-PLLIST)
    
    (if (and (princ "\nWhlen Sie 3D-Polylinien (ENTER=Ende):")
             (setq aws (ssget  (list (cons 0 "POLYLINE")(cons 410(getvar "CTAB")))))
             (setq vla-PlList (JB_3DPS:SpList:Get:vla-PlList aws)))
      (JB_3DPS:SpList:Get:Intersect vla-PlList)
      )
  )

;;;Coords 3D-Poly in List
(defun JB_3DPS:Dbox1:List:ini:zList:coordList (vla-3DPoly / N SUB X)
  (setq n -1)
  (vl-remove-if 'not
                 (mapcar '(lambda(X)
                            (setq n (+ n 1))
                            (if (= n 2)
                              (progn
                                (setq Sub (cons X Sub))
                                (setq n -1)
                                (Setq X (reverse Sub))
                                (setq Sub nil)
                                X)
                              (progn
                                (setq Sub (cons X Sub))
                                nil))
                            )
                   (vlax-get vla-3DPoly 'Coordinates)))
  )

;;;zList: der akktuelle z-Wert auf 3D-Poly und ein Flag, ob Sttzpunkt oder nicht
(defun JB_3DPS:Dbox1:List:ini:zList (vla-obj xy0 / COORDS N RETXYZ StzVorhanden pStz1 pStz2) 
  (setq coords (JB_3DPS:Dbox1:List:ini:zList:coordList vla-obj))
  (if (and (equal (distance (car coords)(last coords))0.0 0.0001)(=(vla-get-closed vla-obj):vlax-true))
    (setq coords (reverse(cdr(reverse coords)))))
  (if (=(vla-get-closed vla-obj):vlax-true)
    (setq coords (append coords (list (car coords)))))
  (setq n -1)
  (while (and(not Retxyz)
             (< (+ n 1) (length coords)))
    (setq n (+ n 1))

    
      (cond ((equal (distance (JBf_list_xyz->xy0 (nth n coords))xy0)0.0 0.0001);;;Sttzpunkt 2
             (setq pStz1 (nth n coords))
             (setq StzVorhanden 'T)
             (setq Retxyz (nth n coords)))
            ((and (> n 0)(equal (distance (JBf_list_xyz->xy0 (nth (- n 1)coords))xy0)0.0 0.0001));;;Sttzpunkt 1
             (setq pStz1 (nth (- n 1)coords))
             (setq StzVorhanden 'T)
             (setq Retxyz (nth (- n 1)coords)))
            ((and
               (> n 0)
               (equal (distance(polar (JBf_list_xyz->xy0(nth (- n 1)coords));;;wenn auf 3D-Polylinie aber kein Sttzpunkt
                                      (angle (JBf_list_xyz->xy0(nth (- n 1)coords)) xy0)
                                      (distance (JBf_list_xyz->xy0(nth (- n 1)coords))(JBf_list_xyz->xy0 (nth n coords)))
                                      )
                        (JBf_list_xyz->xy0 (nth n coords)))0.0 0.0001)
               (equal (distance(polar (JBf_list_xyz->xy0(nth n coords));;;wenn auf 3D-Polylinie aber kein Sttzpunkt
                                      (angle (JBf_list_xyz->xy0(nth n coords)) xy0)
                                      (distance (JBf_list_xyz->xy0(nth n coords))(JBf_list_xyz->xy0 (nth (- n 1) coords)))
                                      )
                        (JBf_list_xyz->xy0 (nth (- n 1) coords)))0.0 0.0001)
               )
             (setq Retxyz (list (car xy0)(cadr xy0)
                                (+(caddr(nth (- n 1)coords))(*(/(- (caddr (nth n coords))(caddr(nth (- n 1)coords)))
                                                                (distance (JBf_list_xyz->xy0 (nth n coords))(JBf_list_xyz->xy0(nth (- n 1)coords))))
                                                              (distance xy0(JBf_list_xyz->xy0(nth (- n 1)coords))))))
                   pStz1 (nth (- n 1) coords)
                   pStz2 (nth n coords))
             )
            )
          )
    

  (list (caddr Retxyz) StzVorhanden pStz1 pStz2)
  )
                            


;;;ListenInitialisierung
(defun JB_3DPS:Dbox1:List:ini (l1_selFlag / L N M X Y Z z1List z2List)
  (setq n 0)
  (setq l1&Dbox1
         (apply 'append
                (mapcar '(lambda(X)
                           (setq n (+ n 1))
                           (setq l 0)
                           (apply 'append
                           (mapcar '(lambda(Y)
                                      (setq l (+ l 1))
                                      (setq m 0)
                                      (mapcar '(lambda(Z)
                                                 (setq m (+ m 1))
                                                 (setq z1List (JB_3DPS:Dbox1:List:ini:zList (cadr (car X))Z))
                                                 (setq z2List (JB_3DPS:Dbox1:List:ini:zList (cadr(cadr Y))Z))
                                                 (list (cons "IndexList"(list n l m))
                                                       (cons "vla-obj1"(cadr (car X)))
                                                       (cons "vla-obj2"(cadr(cadr Y)))
                                                       (cons "xy0" Z)
                                                       (cons "z1" (car z1List))
                                                       (cons "Stz1vorhanden" (cadr z1List))
                                                       (cons "Stz1Start" (caddr z1List))
                                                       (cons "Stz1Ende" (cadddr z1List))
                                                       (cons "z2" (car z2List))
                                                       (cons "Stz2vorhanden" (cadr z2List))
                                                       (cons "Stz2Start" (caddr z2List))
                                                       (cons "Stz2Ende" (cadddr z2List))
                                                       (cons "zEdit" (car z1List))
                                                       )
                                                 )
                                        (car Y))
                                      )
                             (cadr X)
                             )
                                  )
                           )
                  spList&Dbox1)))
  (if l1_selFlag
    (setq l1_sel&Dbox1 0)
    )
  )
    



;;;DBox 1
(defun JB_3DPS:Dbox1 (v_liste pfad_ini / DclId ok l1&Dbox1 l1_sel&Dbox1)

  (setq Settings&Dbox1 (JB_3DPS:v_liste:DboxSettings:get "Dbox1" v_liste))
  
  
  
      
  (while (not (member ok '(99)))

    (setq DclId (JBf_Dcl:Load_dialog JB_3DPS_$DCL$_File "JB_3DPS_1" JB_3DPS$DCL$_1_po))

    (JB_3DPS:Dbox1:set)
    (JB_3DPS:Dbox1:mode)
    
    
    (mapcar '(lambda (A) (action_tile A (strcat "(JB_3DPS:Dbox1:action \"" A "\")")))
            '("JB_1_b1" "JB_1_b2" "JB_1_b3" "JB_1_b4"      
              "JB_1_l1"              
              "JB_1_r3" "JB_1_r4" "JB_1_r5"
              "JB_1_b0" "cancel"
             )
    )
    (setq ok (start_dialog))
    (unload_dialog DclId)

    
      
    
    (cond ((= ok 99) ;;;Ende
           (setq v_liste (JB_3DPS:v_liste:DboxSettings:put "Dbox1" Settings&dbox1 v_liste))
           (JBf_SIC:sichern v_liste pfad_ini nil)
           )
          ((= ok 10);;;3E-Polylinien whlen
           (if (setq spList&Dbox1 (JB_3DPS:SpList:Get))
             (JB_3DPS:Dbox1:List:ini 'T))
           )
             
          ((= ok 12)
           (vl-catch-all-apply 'getpoint (list (trans(cdr(assoc "xy0" (nth l1_sel&Dbox1 l1&Dbox1)))0 1) "\nmit ENTER zurck ins Dialogfenster."))
           )
          ((= ok 13)
           (sssetfirst (ssadd(vlax-vla-object->ename(cdr(assoc "vla-obj1" (nth l1_sel&Dbox1 l1&Dbox1)))))(ssadd(vlax-vla-object->ename(cdr(assoc "vla-obj1" (nth l1_sel&Dbox1 l1&Dbox1))))))
           (vl-catch-all-apply 'getpoint (list (trans(cdr(assoc "xy0" (nth l1_sel&Dbox1 l1&Dbox1)))0 1) "\nmit ENTER zurck ins Dialogfenster."))
           (sssetfirst nil nil)
           )
          ((= ok 14)
           (sssetfirst (ssadd(vlax-vla-object->ename(cdr(assoc "vla-obj2" (nth l1_sel&Dbox1 l1&Dbox1)))))(ssadd(vlax-vla-object->ename(cdr(assoc "vla-obj2" (nth l1_sel&Dbox1 l1&Dbox1))))))
           (vl-catch-all-apply 'getpoint (list (trans(cdr(assoc "xy0" (nth l1_sel&Dbox1 l1&Dbox1)))0 1) "\nmit ENTER zurck ins Dialogfenster."))
           (sssetfirst nil nil)
           )
          )
    ) 
  )

    
   
;;;Action (Variable global in Aufrufender Funktion)
(defun JB_3DPS:Dbox1:action (key / NAME X)

  (cond
    ((= key "JB_1_r3")
     (if (= $value "1")
       (progn
         (JB_3DPS:Dbox1:get)
         (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 0 "JB_1_r3-r5"))
         (JB_3DPS:Dbox1:mode)
         )
     ))
    ((= key "JB_1_r4")
     (if (= $value "1")
       (progn
         (JB_3DPS:Dbox1:get)v
         (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 1 "JB_1_r3-r5"))
         (JB_3DPS:Dbox1:mode)
         )
     ))
    ((= key "JB_1_r5")
     (if (= $value "1")
       (progn
         (JB_3DPS:Dbox1:get)
         (setq Settings&dbox1 (JBf_list:subst:gc Settings&dbox1 2 "JB_1_r3-r5"))
         (JB_3DPS:Dbox1:mode)
         )
     ))
    ((= key "JB_1_l1")
     (JB_3DPS:Dbox1:get)
     (setq l1_sel&Dbox1 (atoi $value))
     (JB_3DPS:Dbox1:set)
     (if (= $reason 4)
       (progn
         (JB_3DPS:Dbox1:get)
         (setq JB_3DPS$DCL$_1_po (done_dialog 12))
         
         )
       )
     )

    ((= key "JB_1_b0")
     (JB_3DPS:Dbox1:get)     
     (setq JB_3DPS$DCL$_1_po (done_dialog 10))
     )
    
    ((= key "JB_1_b1")
     (JB_3DPS:Dbox1:get)
         (JB_3DPS:Dbox1:action:b1)
     )
    ((= key "JB_1_b2")
     (JB_3DPS:Dbox1:get)     
     (setq JB_3DPS$DCL$_1_po (done_dialog 12))
     )
    ((= key "JB_1_b3")
     (JB_3DPS:Dbox1:get)     
     (setq JB_3DPS$DCL$_1_po (done_dialog 13))
     )
    ((= key "JB_1_b4")
     (JB_3DPS:Dbox1:get)     
     (setq JB_3DPS$DCL$_1_po (done_dialog 14))
     )
    ((= key "cancel") ;;;Ende
     (setq JB_3DPS$DCL$_1_po (done_dialog 99))
     )
    )
    
)



(defun JB_3DPS:Dbox1:action:b1:Done (vla-obj xy0 z stzStart stzEnde stzVorhanden / COORDS COORDS1 COORDS2 ENDFLAG FLAG STARTFLAG VLA-OBJ1 X)
  (setq coords (JB_3DPS:Dbox1:List:ini:zList:coordList vla-obj))
  (if (not stzVorhanden)
    (setq coords
           (apply 'append
                  (mapcar '(lambda(X)
                             (if (not StartFlag)
                               (if (equal (distance X stzStart)0.0 0.0001)
                                 (progn
                                   (setq StartFlag 'T)
                                   (list X
                                         (list (car xy0)(cadr xy0)z))
                                   )
                                 (list X)
                                 )
                               (if (not EndFlag)
                                 (if (equal (distance X stzEnde)0.0 0.0001)
                                   (progn
                                     (setq EndFlag 'T)
                                     (list X))
                                   (list X))
                                 (list X)
                                 )
                               )
                             )coords)))
    (setq coords
           (mapcar '(lambda(X)
                      (if (equal (distance (JBf_list_xyz->xy0 X)xy0)0.0 0.0001)
                        (list (car xy0)(cadr xy0)z)
                        X))coords))
    )
  (vlax-put vla-obj 'Coordinates (apply 'append coords))
  (vla-update vla-obj)
  
    
  )
 

;;;Action b1: Bruch oder Sttzpunkt einfgen, wenn geschehen, dann aus Liste aussortieren
(defun JB_3DPS:Dbox1:action:b1 ( / L1SUB N X)
  
  (setq l1Sub (nth l1_sel&Dbox1 l1&Dbox1))
  (JB_3DPS:Dbox1:action:b1:Done
    (cdr(assoc "vla-obj1" l1Sub))
    (cdr(assoc "xy0" l1Sub))
    (cond ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))0)
           (cdr(assoc "z1" l1Sub)))
          ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))1)
           (cdr(assoc "z2" l1Sub)))
          ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))2)
           (cdr(assoc "zEdit" l1Sub)))
          )
    
    (cdr(assoc "Stz1Start" l1Sub))
    (cdr(assoc "Stz1Ende" l1Sub))
    (cdr(assoc "Stz1vorhanden" l1Sub)))

  (JB_3DPS:Dbox1:action:b1:Done
    (cdr(assoc "vla-obj2" l1Sub))
    (cdr(assoc "xy0" l1Sub))
    (cond ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))0)
           (cdr(assoc "z1" l1Sub)))
          ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))1)
           (cdr(assoc "z2" l1Sub)))
          ((= (cdr(assoc "JB_1_r3-r5" Settings&dbox1))2)
           (cdr(assoc "zEdit" l1Sub)))
          )
    (cdr(assoc "Stz2Start" l1Sub))
    (cdr(assoc "Stz2Ende" l1Sub))
    (cdr(assoc "Stz2vorhanden" l1Sub)))

  (setq spListSub (car(vl-remove-if (function(lambda(X)(/=(vla-get-Handle(cdr(assoc "vla-obj1" l1Sub)))(car(car X)))))spList&Dbox1)))
  (setq spListSub (list (car spListSub)
                        (vl-remove-if (function(lambda(X)(=(vla-get-Handle(cdr(assoc "vla-obj2" l1Sub)))(car(cadr X)))))(cadr spListSub)))) 
  (if (not (cadr spListSub))
    (setq spList&Dbox1 (vl-remove-if (function(lambda(X)(=(vla-get-Handle(cdr(assoc "vla-obj1" l1Sub)))(car(car X)))))spList&Dbox1))
    (setq spList&Dbox1 (mapcar (function(lambda(X)(if (=(vla-get-Handle(cdr(assoc "vla-obj1" l1Sub)))(car(car X)))spListSub X)))spList&Dbox1))
    )
  (JB_3DPS:Dbox1:List:ini nil)

  (setq n -1)  
  (if l1&Dbox1
    (if (> l1_sel&Dbox1 0)
      (setq l1_sel&Dbox1 (- l1_sel&Dbox1 1)))
    (setq l1_sel&Dbox1 nil))
  (JB_3DPS:Dbox1:set)
  (JB_3DPS:Dbox1:mode)
  )
  


;;;DBox1: getten
(defun JB_3DPS:Dbox1:get ( / )
  (if l1_sel&Dbox1
    (progn
      (setq l1Sub (nth l1_sel&Dbox1 l1&Dbox1))
      (setq l1Sub (JBf_list:subst:gc l1Sub (atof(vl-string-subst "." ","(get_tile "JB_1_e1")))"zEdit"))
      (setq l1&Dbox1 (JBf_list:nth:change l1&Dbox1 l1Sub l1_sel&Dbox1))
      )
    )
  )

;;;Nummerierung Alphanumerisch
(defun JB_3DPS:Dbox1:set:Alpha (n / )
  (while (> n 26)
    (setq n (- n 26)))
  (vl-list->string(list (nth (- n 1)
         '(65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90)))))
  
         
    
  
    
;;;DBox1: setten
(defun JB_3DPS:Dbox1:set ( / X)
  

  (JBf_Dcl:AddList:New "JB_1_l1"
    (mapcar '(lambda(X)
               (strcat "SP " (JB_3DPS:Dbox1:set:Alpha(car(cdr(assoc "IndexList" X))))"."(itoa(cadr(cdr(assoc "IndexList" X))))"-"(itoa(caddr(cdr(assoc "IndexList" X))))"\t"
                 (rtos(car(cdr(assoc "xy0" X)))2 3) " "
                 (rtos(cadr(cdr(assoc "xy0" X)))2 3)))
      l1&Dbox1)
    )
  (if l1_sel&Dbox1
    (set_tile "JB_1_l1" (itoa l1_sel&Dbox1))
    (set_tile "JB_1_l1" "")
    )

  (mapcar '(lambda(X)(set_tile (strcat "JB_1_"(car X))(cadr X)))
    (list
      (list "r3" (if(=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))0)"1" "0"))
      (list "r4" (if(=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))1)"1" "0"))
      (list "r5" (if(=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))2)"1" "0"))
      (list "t1" (if l1_sel&Dbox1(rtos(cdr(assoc "z1" (nth l1_sel&Dbox1 l1&Dbox1)))2 3)"#.###"))
      (list "t2" (if l1_sel&Dbox1(rtos(cdr(assoc "z2" (nth l1_sel&Dbox1 l1&Dbox1)))2 3)"#.###"))
      (list "e1" (if l1_sel&Dbox1(rtos(cdr(assoc "zEdit" (nth l1_sel&Dbox1 l1&Dbox1)))2 3)"#.###"))
      )))

;;;DBox1, moden
(defun JB_3DPS:Dbox1:mode ( / )

  (if l1_sel&Dbox1
    (progn
      (mode_tile "JB_1_b3" 0)
      (mode_tile "JB_1_b4" 0)
      (mode_tile "JB_1_r3" 0)
      (if (=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))0)
        (mode_tile "JB_1_t1" 0)          
        (mode_tile "JB_1_t1" 1))
      (mode_tile "JB_1_r4" 0)
      (if (=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))1)
        (mode_tile "JB_1_t2" 0)
        (mode_tile "JB_1_t2" 1))
      (mode_tile "JB_1_r5" 0)
      (if (=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))2)
        (mode_tile "JB_1_e1" 0)
        (mode_tile "JB_1_e1" 1))
      (mode_tile "JB_1_b1" 0)
      (mode_tile "JB_1_b2" 0))
    (progn
      (mode_tile "JB_1_b3" 1)
      (mode_tile "JB_1_b4" 1)
      (mode_tile "JB_1_r3" 1)
      (mode_tile "JB_1_r4" 1)
      (mode_tile "JB_1_r5" 1)
      (mode_tile "JB_1_t1" 1)
      (mode_tile "JB_1_t2" 1)
      (mode_tile "JB_1_e1" 1)
      (mode_tile "JB_1_b1" 1)
      (mode_tile "JB_1_b2" 1))
    )
  
        
  (if (not l1_sel&Dbox1)
    (mode_tile "JB_1_b0" 2)
    (if (=(cdr(assoc "JB_1_r3-r5" Settings&dbox1))2)
      (mode_tile "JB_1_e1" 2)
      )
    )
  )


         
;;;DCL-schreiben
(defun JB_3DPS:dcl:Write ( / file)  
  (if (and (setq JB_3DPS_$DCL$_File (vl-filename-mktemp (strcat "3DPS.dcl")))
           (setq file (open JB_3DPS_$DCL$_File "w"))
      )
    (progn
      (mapcar '(lambda (A)
                       (write-line A file)
               )
              (mapcar '(lambda (A)
                               (strcat "\n" A)
                       )
              (list
                "//Hauptdialog"
                "JB_3DPS_1: dialog {label= \"3D-Polylinien - Schnittpunkte\";	 "
                ":boxed_column {label = \"Schnittpunktliste\";"
                ":list_box {key = \"JB_1_l1\";tabs = \"10\";}"
                ":boxed_row{label = \"Z-Wert\";"
                ":radio_column {"
                ":radio_button {key = \"JB_1_r3\"; label = \"Z aus A,B,C....\";width=10;}"
                ":radio_button {key = \"JB_1_r4\"; label = \"Z aus 1,2,3,...\";width=10;}"
                ":radio_button {key = \"JB_1_r5\"; label = \"Z per Eingabe\";width=10;}"
                "}"
                ":column{"
                ":row {"
                ":text {key = \"JB_1_t1\"; label = \"1.234\";width=10;}"
                ":button {key = \"JB_1_b3\"; label = \"CAD<\"; fixed_width=true;}}"
                ":row{"
                ":text {key = \"JB_1_t2\"; label = \"1.235\";width=10;}"
                ":button {key = \"JB_1_b4\"; label = \"CAD<\"; fixed_width=true;}}"
                ":edit_box {key = \"JB_1_e1\";}"
                "}}"
                ":row {"
                ":button {key = \"JB_1_b1\"; label = \"&Anwenden\";width=20;}"
                ":button {key = \"JB_1_b2\"; label = \"&Zoom<\";width=20;}"
                "}"
                "}"
                ":row{fixed_width = true;alignment = centered;"
                ":button {key = \"JB_1_b0\"; label = \"3D-Polylinie whlen<\";width=20;}"
                ":spacer {width = 2;}"
                ":retirement_button {label = \"&Ende\"; key= \"cancel\"; fixed_width = true;is_cancel=true;}"
                "}"
                "}"

               )
              )
      )
      (close file)
      JB_3DPS_$DCL$_File
    )
  )
)


;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine verwaltungstechnische Funktionen							   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Fehlermeldung
;;;Fehlermeldung;;;
(defun JBf_Error  (s)
  (print (strcat "***Fehler*** " s))
  (JBf_Reinit))

;;;Initialisierungsfunktion
(defun JBf_init (InitVaris / )
  (setq	JB_Error *error*
        *error* JBf_Error)
  (vl-load-com)
  ;;;Systemvariablen aktuelle Einstellungen fr ReInit speichern
  (setq JBf$ReInit$Varis
         (mapcar '(lambda(A)
                    (list (car A)(getvar (car A))))InitVaris))
  ;;;Vorgabeeistellungen fr Systemvariablen
  (mapcar '(lambda(A)
             (if (cadr A)
               (setvar (car A)(cadr A))))InitVaris)
  )

;;;Reinitialisierung
(defun JBf_Reinit ( / n)
  ;;;Systemvariablen ReInitialisieren
  (mapcar '(lambda(A)
             (setvar (car A)(cadr A)))JBf$ReInit$Varis)
  (setq JBf$ReInit$Varis nil)
  (princ)
)

;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Strings								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;benutzerspezifischer Pfad zum Speichern von Programmeinstellungen auf dem Benutzer von Windows
;;;bergeben wird der relative Pfad, der hinter den Windows-Pfad angehngt wird. Wenn die Verzeichnisse nicht vorhanden sind werden sie erstellt.
(defun JBf_String:Userpfad:WinUser (UserPfad / )
  
  (setq UserList (JBf_String:Delimiter->List UserPfad "\\"))
  (setq Pfad (strcat "c:\\Users\\"(getvar "LOGINNAME")"\\"))
        

  ;;;wenn UserPfad noch nicht vorhanden, dann erstellen
  (mapcar '(lambda(A)
             (setq Pfad (strcat Pfad A "\\"))
             (if (not (JBf_String:FilePath? Pfad))
               (vl-mkdir Pfad)))
    UserList)
  Pfad
  )
;;;String anhand Trennzeichen in Liste zurckgeben
(defun JBf_String:Delimiter->List (Str Delim / StrList)
  (setq Str (vl-string-left-trim Delim Str)
	Str (vl-string-right-trim Delim Str))
  (if (vl-string-search Delim Str)
    (progn
      (while (vl-string-search Delim Str)
        (setq StrList (cons (substr Str 1 (vl-string-search Delim Str))StrList)
	      Str (vl-string-left-trim Delim(substr Str(+(vl-string-search Delim Str)(+ (strlen Delim)1))))))
      (if (/= Str "")
        (setq StrList (cons Str StrList))))
    (setq StrList (cons Str StrList)))
  (reverse StrList))


;;;Dateipfad prfen
(defun JBf_String:FilePath? (Pfad / FSO TRUE-FALSE)
  (setq Pfad (if(vl-string-search "." Pfad)(car(fnsplitl  Pfad))Pfad))
  (if (setq FSO (vlax-create-object "Scripting.FilesystemObject"))
    (progn
      (if (vlax-method-applicable-p FSO 'FOLDEREXISTS)
        (setq TRUE-FALSE
               (=(vl-catch-all-apply
                   'vlax-invoke-method
                   (list FSO 'FOLDEREXISTS Pfad)):vlax-true))
        (vlax-release-object FSO))))
  TRUE-FALSE)
	  
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen								   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Es wird der GcN-Eintrag gesubst
(defun JBf_list:subst:gc (liste Wert GcN / )
  (subst (cons GcN Wert)(assoc GcN liste)liste))


         
;;;Bessere Version
(defun JBf_list:nth:change(liste EintragNew pos / n )
  (setq n -1)
  (mapcar '(lambda (A)
             (setq n (+ n 1))
             (if (= n pos)
               EintragNew
               A))liste))




(defun JBf_list_xyz->xy0 (list_xyz / )
  (if (=(length list_xyz)2)
    (reverse(cons 0.0 (reverse list_xyz)))
    (reverse(cons 0.0 (cdr(reverse list_xyz)))))
  )

;;;Schnittpunkte zweier Linienobjekte
(defun JBf_List:ObjSchnitt (obj1 obj2 / SpArray)

  (setq SpArray (vlax-invoke-method (vlax-ename->vla-object obj1)
                                    'IntersectWith
                                    (vlax-ename->vla-object obj2) acExtendNone
                )
  )

  (if (/= -1 (vlax-safearray-get-u-bound (vlax-variant-value SpArray) 1))
    (JBf_List:ObjSchnitt:ArrayList->List (vlax-safearray->list (vlax-variant-value SpArray)) 3)
  )
)

;;;ArrayList in normale Liste
(defun JBf_List:ObjSchnitt:ArrayList->List (ArrayList i / A N RETLIST SUBLIST)
  (setq n 0)
  (mapcar '(lambda (A)
                   (setq n (+ n 1)
                         subList (cons A subList)
                   )
                   (if (= n i)
                     (setq retList (cons (reverse subList) retList)
                           n 0
                           subList nil
                     )
                   )
           )
          ArrayList
  )
  retList
  )

;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Listen in SIC-Datei sichern  					   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Liste in LSP-Datei sichern
;;;Sichern von Einstellungen, Ausfhrung
;;;liste => DottetPairList, die es zu sichern gilt
;;;path => vollstndiger Dateipfad mit Dateiname
;;;AcadTrustCheck => 'T or NIL, es wird bei 'T ein temnporrer TrustedPath erstellt und danach auch gleich wieder gelscht
(defun JBf_SIC:sichern (liste FilePath AcadTrustCheck / FILESTREAM X)

  (setq FileStream (open FilePath "w"))
  (write-line "'(" FileStream)
  (mapcar '(lambda (X)
                   (JBf_SIC:sichern:prin1 X FileStream)
           )
          liste
  )
  (write-line ")" FileStream)
  (close FileStream)

  (if
    (if AcadTrustCheck
      (car (JBf_SIC:load:Catch FilePath nil))
      (vl-catch-all-error-p
        (vl-catch-all-apply 'JBf_SIC:load (list FilePath))
      )
    )


    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (progn
        (alert (strcat "Die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n ist fehlerhaft und wird automatisch durch die BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nersetzt."
               )
        )
        (if (vl-file-delete FilePath)
          (vl-file-copy (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak") FilePath)
          (alert (strcat "Die Sicherungsdatei \n\n"
                         FilePath
                         "\n\n ist fehlerhaft und konnte nicht automatisch durch die BAK-Datei\n\n"
                         (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                         "\n\nersetzt werden. Bitte fhren Sie diesen Arbeitsgang manuell durch."
                 )
          )
        )
      )

      (alert (strcat "Die Sicherungsdatei \n\n"
                     FilePath
                     "\n\n ist fehlerhaft, bitte lschen Sie diese, anderfalls kann das Programm nicht mehr\n"
                     "ordnungsgem starten."
             )
      )
    )
    (if (findfile (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
      (if (vl-file-delete (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
        (alert (strcat "Fr die Sicherungsdatei \n\n"
                       FilePath
                       "\n\n konnte keine BAK-Datei erstellt werden. Bitte lschen Sie die vorh. BAK-Datei\n\n"
                       (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak")
                       "\n\nmanuell."
               )
        )
      )
      (vl-file-copy FilePath (strcat (car (fnsplitl FilePath)) (cadr (fnsplitl FilePath)) ".bak"))
    )
  )
)
;;;Laden der Datei um zu prfen, ob diese korrekt ist!
  (defun JBf_SIC:load (FilePath /)
    (load FilePath)
  )
;;;Pfad muss existieren, Prfung in aufrufender Funktion und temporrem TrustPath
  (defun JBf_SIC:load:Catch (PathFile ErrMsg / ERROR RETVAL TRUTHPATHSET)
    (if (JBf_AcadSystem:TrustedPaths?)
      (progn
        (setq TruthPathSet 'T)
        (JBf_AcadSystem:TrustedPaths:Add (strcat (car (fnsplitl PathFile)) "..."))
      )
    )

    (setq error (vl-catch-all-error-p
                  (setq RetVal (vl-catch-all-apply 'JBf_SIC:load (list PathFile)))
                )
    )
    (if (and error ErrMsg)
      (alert ErrMsg)
    )

    (if TruthPathSet
      (JBf_AcadSystem:TrustedPaths:Delete (strcat (car (fnsplitl PathFile)) "..."))
    )


    (list error RetVal)
  )
;;;Iteratives lustiges Listenschreiben
  (defun JBf_SIC:sichern:prin1 (A FileStream / B)

    (cond  ;;;wenn einzelner Eintrag
                 ((atom A)
                        (write-line (vl-prin1-to-string A) FileStream)
                 )
      ((and (atom (car A)) (not (cdr A)))  ;;;GC ohne Wert
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (not (listp (cdr A))))  ;;;DottedPair
            (write-line (vl-prin1-to-string A) FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)) (= (length (cdr A)) 1) (atom (car (cdr A))))  ;;;GC + Wert
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ((and (atom (car A)) (cdr A) (listp (cdr A)))  ;;;GC + Liste
            (write-line (strcat "(" (vl-prin1-to-string (car A))) FileStream)
            (mapcar '(lambda (B)
                             (JBf_SIC:sichern:prin1 B FileStream)
                     )
                    (cdr A)
            )
         (write-line ")" FileStream)
      )
      ( 'T
        (write-line "(" FileStream)
        (mapcar '(lambda (B)
                         (JBf_SIC:sichern:prin1 B FileStream)
                 )
                A
        )
         (write-line ")" FileStream)
      )
    )
  )             

;;;--------------------------------------------------------------------------------------------------------
;;;Setzen von "TrustedPaths's" sab ACAD  2014								   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;Prfen, ob bereits TrustedPaths in der aktuelle Version verwendet werden knnen
(defun JBf_AcadSystem:TrustedPaths? ( / )
  (and (= "ACAD" (strcase (getvar "PROGRAM"))) (getvar "SECURELOAD"))
  )

;;;Pfadangaben immer mit BackSlashes, "\\..." hinten angestellt, damit alle untergeordneten Verzeichnisse bercksichtigt werden
(defun JBf_AcadSystem:TrustedPaths:Add (pfad / TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (if(not(member (strcase pfad)(mapcar 'strcase (JBfd_AcadSystem:TrustedPath:Split TrustedPaths))))
    (setvar "TRUSTEDPATHS"(strcat TrustedPaths ";" pfad)))
  )

;;;Pfad entfernen
(defun JBf_AcadSystem:TrustedPaths:Delete (pfad / A TRUSTEDPATHS)
  (setq TrustedPaths(if (getvar "TRUSTEDPATHS")(getvar "TRUSTEDPATHS")""))
  (setvar "TRUSTEDPATHS"
	  (vl-string-right-trim ";"(apply 'strcat(mapcar '(lambda(A)
							   (strcat A ";"))
							(vl-remove-if 'not (mapcar '(lambda(A)
										      (if(/= (strcase pfad)(strcase A))A))
										   (JBfd_AcadSystem:TrustedPath:Split TrustedPaths)))))))
  )

;;;String splitten an Semikolons, als Liste zurckgeben
(defun JBfd_AcadSystem:TrustedPath:Split (TrustedPaths / A RETLIST TEMP)
  (mapcar '(lambda(A)
	     (if (/= A 59)
	       (setq temp (cons A temp))
	       (setq RetList (cons (vl-list->string(reverse temp))RetList)
		     temp nil))
	     )
	     (vl-string->list TrustedPaths))
  (if temp
    (setq RetList (cons (vl-list->string (reverse temp))RetList)))
  (reverse RetList))
;;;--------------------------------------------------------------------------------------------------------
;;;allgemeine Funktionen => Dcl									   	   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

;;;DCL-Dialogfenster laden
(defun JBf_Dcl:Load_dialog (FileName DialogName JB_$DCL$_x_po / DclId)
  (setq DclId (load_dialog FileName))
  (if	JB_$DCL$_x_po
    (if (not (new_dialog DialogName DclId "" JB_$DCL$_x_po))
      (exit))
    (if (not (new_dialog DialogName DclId))
      (exit)))
  DclId
  )

;;;DCL-Liste komplett neu fllen
(defun JBf_Dcl:AddList:New (key liste / )
  (start_list key 3)
  (mapcar 'add_list liste)
  (end_list)
  )

;;;--------------------------------------------------------------------------------------------------------
;;;Info fr Textfenster nach dem laden des Programms							   
;;;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

(princ (strcat
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          "\n|3D-Polylinien - Schnittpunkte.                              |"
          "\n|------------------------------------------------------------|"
          "\n|erstellt durch Bosse-engineering - www.bosse-engineering.com|"
          "\n|------------------------------------------------------------|"
          "\n|Befehlszeilenaufruf: 3DPS                                   |"
          "\n|++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++|"
          )
       )
(princ)



      









